package nemosofts.voxradio.utils;

import android.content.Context;
import android.net.Uri;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.C;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultDataSourceFactory;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.exoplayer.upstream.DefaultBandwidthMeter;


public class RecorderPlayer {

    private final Context ctx;

    private static ExoPlayer exoPlayerRecorder = null;

    public static ExoPlayer getExoPlayer() {
        return exoPlayerRecorder;
    }

    public static void setExoPlayer(ExoPlayer exoPlayer) {
        exoPlayerRecorder = exoPlayer;
    }

    @NonNull
    public static Boolean getIsPlaying() {
        if (exoPlayerRecorder != null) {
            return exoPlayerRecorder.getPlayWhenReady();
        }
        return false;
    }

    public RecorderPlayer(Context ctx) {
        this.ctx = ctx;
    }

    public void onCreate() {
        RecorderPlayer.setExoPlayer(new ExoPlayer.Builder(ctx).build());

        AudioAttributes audioAttributes = new AudioAttributes.Builder()
                .setUsage(C.USAGE_MEDIA)
                .setContentType(C.AUDIO_CONTENT_TYPE_MUSIC)
                .build();

        exoPlayerRecorder.setAudioAttributes(audioAttributes, true);
    }

    @OptIn(markerClass = UnstableApi.class)
    public void setUrl(String finalUrl) {
        DataSource.Factory dataSourceFactory = new DefaultDataSourceFactory(
                ctx,
                Util.getUserAgent(ctx, "ExoPlayerDemo"),
                new DefaultBandwidthMeter.Builder(ctx).build()
        );
        MediaSource mediaSource = new ProgressiveMediaSource.Factory(dataSourceFactory)
                .createMediaSource(MediaItem.fromUri(Uri.parse(finalUrl)));
        exoPlayerRecorder.setMediaSource(mediaSource);
        exoPlayerRecorder.prepare();
        exoPlayerRecorder.setPlayWhenReady(true);
    }

    public static void onStopAudio() {
        try {
            if (exoPlayerRecorder != null){
                exoPlayerRecorder.stop();
                exoPlayerRecorder.release();
                exoPlayerRecorder = null;
            }
        } catch (Exception e) {
            Log.e("RecorderPlayer","Error onStopAudio",e);
        }
    }
}